#!/usr/bin/python
#
#  $Id$
#  Copyright 2003  S. Quandt
#
#  This software is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.

'''
class PlotFrame: A QFrame descendant for 2D plotting.
'''

import sys
from qt import *

false, true = 0, 1

Color = QColor( 0,0,0 )

def AgeColor( i ):
  h,s,v = (i * 8) % 360, 230, 255 * exp( i/-1e3 )
  Color.setHsv( h,s,v )
  return Color

# 4 3210 7654 3210
# s hhhh hhvv vvvv
# s 1bit: 
# h 6bit: Mapped onto range  0 - 255
# v 6bit: Mapped onto range 64 - 255 (step 3)
def QuColor( q ):
  """
  Map q to one of 2^13 colors.
  """
  i = int( q + .5 )
  h,s,v = (i & 0xFC0) >> 2 , (i & 0x1000) and 100 or 220, 64 + (i & 0x3F) * 3
  #if i < 0: h,s,v = i * -100, 240, 120
  #else: h,s,v = i*100, 200, 200
  Color.setHsv( h,s,v )
  return Color

#-------------------------------------------------

def BalloonHelp( msg ):
  """A simple way to show a short contextual message"""
  QWhatsThis.enterWhatsThisMode()
  QWhatsThis.leaveWhatsThisMode( msg )

#=================================================

WRepaintNoErase = 0x00800000	# Qt window flag

class PlotFrame( QFrame ):
  '''A QFrame descendant extended for 2D plotting'''

  def __init__( self, mw, XRange, YRange = None ):
    QFrame.__init__( self, mw )   #apply( QFrame.__init__, (self, mw) )
    self.setFrameStyle( QFrame.Box | QFrame.Raised )
    self._pixmap = None
    self.setWFlags( WRepaintNoErase )
    self.setMouseTracking( true )
    if not YRange: YRange = XRange
    self._translation  = ( -XRange[ 0 ],  -YRange[ 0 ] )
    self._range  = ( float( XRange[ 1 ] - XRange[ 0 ] ),  float( YRange[ 1 ] - YRange[ 0 ] ) )
    #    self._pixmap = QPixmap( self.size() )
    self.resizeEvent()

  def xform( self, x, y ):
    """
    Floating point version of the model to device coordinate transformation.
    """
    return QPoint( x * self._xa + self._xb, y * self._ya + self._yb )
  
  def show( self ):
    """\todo Obsolete?"""
    QFrame.show( self )
    #assert( self.hasFocus() and self.focusPolicy() )
    if self._pixmap:
      self.draw()
    else: self.__class__ + ': Uninitialized self._pixmap in call to show()'

  def draw( self ):
    self._pixmap.fill( QColor( 0, 0, 0 ) )
    painter = QPainter( self._pixmap )
    painter.setPen( QColor( 255,255,255 ) )

    # Draw axis cross.
    painter.drawLine( self.xform( -1, 0 ), self.xform( 1, 0 ) )
    painter.drawLine( self.xform( 0, -1 ), self.xform( 0, 1 ) )
    return painter	# Derived classes may continue drawing
  
  def drawContents( self, painter ):
    bitBlt( self, 0, 0, self._pixmap );

  #
  # Reimplementation of Qt event handlers.
  #
  
  def resizeEvent( self, ev = None ):
    s = self.size()   # s = self.contentsRect();
    print 'Resizing', s.width(), s.height()
    self._xa, self._ya  = s.width() / self._range[ 0 ], -s.height() / self._range[ 1 ]
    self._xb, self._yb  = self._translation[ 0 ] * self._xa, self._translation[ 1 ] * -self._ya
    if self._pixmap:
      del self._pixmap
    self._pixmap = QPixmap( s );

  def keyPressEvent( self, ev ):
    if ev.ascii() == ord( 'q' ):	# Quit?
      sys.exit()

  #  def mouseMoveEvent( self, ev ):    x, y = ev.x(), ev.y()
    

#=================================================

if __name__ == '__main__':
  app = QApplication( sys.argv )
  mw = QMainWindow();	app.setMainWidget( mw )

  pw = PlotFrame( mw, (-5,5), (-5,5) );	mw.setCentralWidget( pw )
  pw.setFocusPolicy( QWidget.StrongFocus )	# Default is NoFocus :(

  mw.setFocusProxy( pw )
  mw.setFocus()
  mw.resize( 800, 800 )
  mw.show();		app.exec_loop()
